
//================================================== RZNE FUNKCIE ======================================================================



typedef BOOL (WINAPI *SET_DPI_AWARE_PROC)(void);
// Podpora pre High DPI (Vysok rozlenie)
void EnableDPIAwareness() {
    HMODULE hUser32 = GetModuleHandle("user32.dll");
    if (hUser32) {
        SET_DPI_AWARE_PROC pSetProcessDPIAware = (SET_DPI_AWARE_PROC)GetProcAddress(hUser32, "SetProcessDPIAware");
        if (pSetProcessDPIAware) {
            pSetProcessDPIAware();
        }
    }
}



void initscreen(HWND hWnd, HDC* hdcMem, HBRUSH pozadie)
{   RECT rect;
    //odstranenie kontextu zariadenia predoslej bitmapy. Keby tato funkcia...
    //...bola na konci tohoto bloku, ziskany kontext by sa hned odstranil,...
    //...a nikdy by ziaden v programe nebol aktualny.
    DeleteDC(*hdcMem);
    //vytvorenie handle okna
    HDC hdcScreen = GetDC(hWnd); 
    //ziskanie rozmerov okna do premennej struktury rect. 
    GetClientRect(hWnd, &rect);
    //vytvorii pamatove HDC kompatibilne s HDC okna
    *hdcMem = CreateCompatibleDC(hdcScreen); 
    //Vytvori rastrovy obrazok kompatibilny s oknom. ...
    //...Parametre: hdc okna, sirka bmp, vyska bmp (v tomto pripade na cele okno)
    HBITMAP hBitmap = CreateCompatibleBitmap(hdcScreen, rect.right, rect.bottom); 
    //vlozenie bitmapy do pamatoveho kontextu zariadenia (virtualnej obrazovky)
    SelectObject(*hdcMem, hBitmap);   
    //skopirovanie obsahu okna do pamatovej virtualnej obrazovky, do bitmapy.
    //BitBlt(*hdcMem,0,0,rect.right, rect.bottom, hdcScreen,0,0,SRCCOPY); 
    //stetec na vymalovanie bitmapy (pozadia pre okno)
    FillRect(*hdcMem, &rect, pozadie);
    //zmazanie handle okna
    ReleaseDC(hWnd, hdcScreen);
    DeleteObject(hBitmap);  	
}



int pauza(int cas)
{	if(((g_timer_pocet+=(cas)) == g_timer_pocitadlo) || (cas == 0))	
		return 1;
	else
		return 0;
}



void pauza_reset()
{	if(g_timer_pocet <= g_timer_pocitadlo)
		g_timer_pocitadlo = 0;
	g_timer_pocet = 0;	
	
}




void Ladenie(LPCTSTR text, int hodnota)
{
	_stprintf(textRX, " %s %d ", text, hodnota);		//premena znaku na cislo
    //Vlozi znak odriadkovania
    //lstrcat(textRX, g_novyRiadok);
	// vlozi zadany text do textoveho editboxu
	SendDlgItemMessage(g_hwndDlg, ID_EDIT_TX_HISTORY, EM_REPLACESEL, FALSE, (LPARAM)textRX);
	//nastavi poziciu na zaciatok textu textoveho editboxu (wParam = zaciatok, lParam = koniec vyberu)
	SendDlgItemMessage(g_hwndDlg, ID_EDIT_TX_HISTORY, EM_SETSEL, 0, 0);	
}




void Ladenie_okno(HWND hwnd, LPCTSTR text, int hodnota)
{
	TCHAR szText[64]; // Buffer pre vsledn text
    wsprintf(szText, TEXT(" %s %d "), text, hodnota);
    MessageBox(hwnd, szText, TEXT("Informcia o rchlosti"), MB_OK | MB_ICONINFORMATION);
}





void Vlastne_Tlacitko(LPARAM lParam, 
					int ID_Tlacitka, 
					COLORREF Farba, 
					COLORREF Farba_okraja, 
					COLORREF Farba_stlaceneho,  
					COLORREF Farba_pisma)
{
    LPDRAWITEMSTRUCT pdis = (LPDRAWITEMSTRUCT)lParam;
        
    if (pdis->CtlID == ID_Tlacitka)
    {
        HDC hdc = pdis->hDC;
        RECT rc = pdis->rcItem;

        // 1. Rieenie textry v rohoch. Nastavme pvod (offset) tetca tak, aby textra v tlaidle 
        // nadvzovala na textru v pozad okna.
        POINT pt = {0, 0};
        MapWindowPoints(pdis->hwndItem, GetParent(pdis->hwndItem), &pt, 1);
        SetBrushOrgEx(hdc, -pt.x, -pt.y, NULL);
        
        // 2. Vyplnme cel plochu tlaidla textrou okna (hTexturaBrush mus by globlna)
        FillRect(hdc, &rc, hTexturaBrush);

        // 3. VBER FARBY (Pridan stav ODS_DISABLED)
        HBRUSH hBrush;
        COLORREF aktualnaFarbaPisma = Farba_pisma;

        if (pdis->itemState & ODS_DISABLED) 
        {
            // Farba pre vypnut tlaidlo (napr. tmavosiv)
            hBrush = CreateSolidBrush(RGB(244, 244, 244));
            // Text urobme tie nevrazn
            aktualnaFarbaPisma = RGB(131, 131, 131); 
        }
        else if (pdis->itemState & ODS_SELECTED) 
        {
            hBrush = CreateSolidBrush(Farba_stlaceneho);
        }
        else 
        {
            hBrush = CreateSolidBrush(Farba);
        }

        // 4. Farby okraja pre vypnut a zapnut tlatko
        COLORREF farbaOkraja = (pdis->itemState & ODS_DISABLED) ? RGB(131, 131, 131) : Farba_okraja;
        HPEN hPen = CreatePen(PS_SOLID, 1, farbaOkraja);
        
        HBRUSH hOldBrush = (HBRUSH)SelectObject(hdc, hBrush);
        HPEN hOldPen = (HPEN)SelectObject(hdc, hPen);
		
		//Zaoblen okraj tlatka
        RoundRect(hdc, rc.left, rc.top, rc.right, rc.bottom, 7, 7);

        // 5. Zobrazenie textu v zadanej farbe
        TCHAR szText[MAX_PATH];
        GetWindowText(pdis->hwndItem, szText, MAX_PATH);
        SetBkMode(hdc, TRANSPARENT);
        SetTextColor(hdc, aktualnaFarbaPisma);
        DrawText(hdc, szText, -1, &rc, DT_CENTER | DT_VCENTER | DT_SINGLELINE);

        // Upratovanie
        SelectObject(hdc, hOldBrush);
        SelectObject(hdc, hOldPen);
        DeleteObject(hBrush);
        DeleteObject(hPen);
    }
}








void Vlastne_Tlacitko_S_Obrazkom(LPARAM lParam, int ID_Tlacitka, HBITMAP hIkonka, COLORREF Farba)
{
    LPDRAWITEMSTRUCT pdis = (LPDRAWITEMSTRUCT)lParam;
    if (pdis->CtlID == ID_Tlacitka)
    {
        HDC hdc = pdis->hDC;
        RECT rc = pdis->rcItem;

        // 1. Pozadie (textra okna v rohoch)
        POINT pt = {0, 0};
        MapWindowPoints(pdis->hwndItem, GetParent(pdis->hwndItem), &pt, 1);
        SetBrushOrgEx(hdc, -pt.x, -pt.y, NULL);
        FillRect(hdc, &rc, hTexturaBrush);

        // 2. Telo tlaidla
        HBRUSH hBrush = CreateSolidBrush(Farba);
        SelectObject(hdc, hBrush);
        RoundRect(hdc, rc.left, rc.top, rc.right, rc.bottom, 15, 15);

        // 3. Vykreslenie ikony (ak existuje)
        if (hIkonka)
        {
            HDC hdcMem = CreateCompatibleDC(hdc);
            SelectObject(hdcMem, hIkonka);
            // Vykreslme ikonu na pozciu x=5, y=5 (predpokladme vekos 16x16)
            BitBlt(hdc, rc.left + 5, rc.top + (rc.bottom-16)/2, 16, 16, hdcMem, 0, 0, SRCCOPY);
            DeleteDC(hdcMem);
        }

        // 4. Text (posunut doprava, aby neprekrval ikonu)
        RECT rcText = rc;
        rcText.left += 25; // Odsadenie pre ikonu
        
        TCHAR szText[MAX_PATH];
        GetWindowText(pdis->hwndItem, szText, MAX_PATH);
        SetBkMode(hdc, TRANSPARENT);
        DrawText(hdc, szText, -1, &rcText, DT_LEFT | DT_VCENTER | DT_SINGLELINE);

        DeleteObject(hBrush);
    }
}



/*
void Vlastny_ComboBox(LPARAM lParam, COLORREF Farba_pozadia, COLORREF Farba_pisma)
{
    LPDRAWITEMSTRUCT pdis = (LPDRAWITEMSTRUCT)lParam;

    // itemID == -1 znamen, e sa kresl statick as (edit pole), nie poloka v zozname
    if (pdis->itemID == (UINT)-1) return; 

    HDC hdc = pdis->hDC;
    RECT rc = pdis->rcItem;

    // 1. Vber farieb poda stavu (vybrat poloka vs. ben)
    HBRUSH hBrush;
    if (pdis->itemState & ODS_SELECTED)
        hBrush = CreateSolidBrush(RGB(0, 120, 215)); // Vaa modr
    else
        hBrush = CreateSolidBrush(Farba_pozadia);

    //FillRect(hdc, &rc, hBrush);
    RoundRect(hdc, rc.left, rc.top, rc.right, rc.bottom, 8, 8); // Menie zaoblenie ako na tlaidle

    // 2. Vykreslenie textu poloky
    TCHAR szText[MAX_PATH];
    SendMessage(pdis->hwndItem, CB_GETLBTEXT, pdis->itemID, (LPARAM)szText);
    
    SetBkMode(hdc, TRANSPARENT);
    SetTextColor(hdc, (pdis->itemState & ODS_SELECTED) ? RGB(255, 255, 255) : Farba_pisma);
    
    // Odsadme text trochu od okraja, aby to vyzeralo lepie
    rc.left += 5;
    DrawText(hdc, szText, -1, &rc, DT_SINGLELINE | DT_VCENTER);

    // 3. Upratovanie
    DeleteObject(hBrush);
}
//*/


/*
void Vlastny_ComboBox(LPARAM lParam, COLORREF Farba_pozadia, COLORREF Farba_pisma)
{
    LPDRAWITEMSTRUCT pdis = (LPDRAWITEMSTRUCT)lParam;
    HDC hdc = pdis->hDC;
    RECT rc = pdis->rcItem;

    if (pdis->itemID == -1) return;

    // 1. Prprava nstrojov
    HBRUSH hBrush;
    COLORREF textCol;

    if (pdis->itemState & ODS_SELECTED) {
        hBrush = CreateSolidBrush(RGB(0, 120, 215)); // Modr pri vbere
        textCol = RGB(255, 255, 255);                // Biely text
    } else {
        hBrush = CreateSolidBrush(Farba_pozadia);    // Vaa definovan farba
        textCol = Farba_pisma;
    }

    // Pero pre jemn okraj (aby RoundRect mal hranicu)
    HPEN hPen = CreatePen(PS_SOLID, 1, RGB(180, 180, 180)); 

    // 2. Vber do HDC a uloenie pvodnch objektov
    HBRUSH hOldBrush = (HBRUSH)SelectObject(hdc, hBrush);
    HPEN hOldPen = (HPEN)SelectObject(hdc, hPen);

    // 3. Samotn kreslenie zaoblenho vntra
    // RoundRect teraz pouije hBrush na vntro a hPen na okraj
    RoundRect(hdc, rc.left, rc.top, rc.right, rc.bottom, 8, 8);

    // 4. Vykreslenie textu
    TCHAR szText[MAX_PATH];
    SendMessage(pdis->hwndItem, CB_GETLBTEXT, pdis->itemID, (LPARAM)szText);
    
    SetBkMode(hdc, TRANSPARENT);
    SetTextColor(hdc, textCol);
    
    RECT rcText = rc;
    rcText.left += 5; // Odsadenie textu
    DrawText(hdc, szText, -1, &rcText, DT_SINGLELINE | DT_VCENTER);

    // 5. UPRATOVANIE (Kov krok, aby sa nepokazili in prvky)
    SelectObject(hdc, hOldBrush);
    SelectObject(hdc, hOldPen);
    DeleteObject(hBrush);
    DeleteObject(hPen);
}
//*/



void Vlastny_ComboBox(LPARAM lParam, 
					COLORREF Farba_pozadia, 
					COLORREF Farba_okraja, 
					COLORREF Farba_pisma, 
					COLORREF Farba_vybratej_polozky, 
					COLORREF Farba_okraja_polozky, 
					COLORREF Farba_pisma_polozky)
{
    LPDRAWITEMSTRUCT pdis = (LPDRAWITEMSTRUCT)lParam;
    HDC hdc = pdis->hDC;
    RECT rc = pdis->rcItem;

    if (pdis->itemID == -1) return;
    
    
    // --- OPRAVA ROHOV (Textra okna) ---
    POINT pt = {0, 0};
    MapWindowPoints(pdis->hwndItem, GetParent(pdis->hwndItem), &pt, 1);
    SetBrushOrgEx(hdc, -pt.x, -pt.y, NULL);
    FillRect(hdc, &rc, hTexturaBrush); // hTexturaBrush je v kovov tetec
    

    // 1. Logika vberu farieb
    HBRUSH hBrush;
    COLORREF textCol;
    COLORREF penCol;

    if (pdis->itemState & ODS_DISABLED) 
    {
        // Neaktvny stav
        hBrush = CreateSolidBrush(RGB(244, 244, 244)); //Farba neaktvne
        textCol = RGB(120, 120, 120);            // Zaednut text
        penCol  = RGB(131, 131, 131);        // Siv okraj
    }
    else if (pdis->itemState & ODS_SELECTED) 
    {
        // Vybrat poloka (ke je zoznam otvoren)
        //hBrush = CreateSolidBrush(RGB(0, 120, 215)); 
        hBrush = CreateSolidBrush(Farba_vybratej_polozky); 
        textCol = Farba_pisma_polozky;
        penCol  = Farba_okraja_polozky;//RGB(0, 80, 150);
    }
    else 
    {
        // Ben stav
        hBrush = CreateSolidBrush(Farba_pozadia);
        textCol = Farba_pisma;
        penCol  = Farba_okraja;//RGB(180, 180, 180);            // tandardn svetlosiv okraj
    }

    // 2. Kreslenie
    HPEN hPen = CreatePen(PS_SOLID, 1, penCol);
    HBRUSH hOldBrush = (HBRUSH)SelectObject(hdc, hBrush);
    HPEN hOldPen = (HPEN)SelectObject(hdc, hPen);

    // Zaoblen obdnik (8, 8 je miernejie zaoblenie vhodn pre menie prvky)
    RoundRect(hdc, rc.left, rc.top, rc.right, rc.bottom, 8, 8);

    // 3. Text
    TCHAR szText[MAX_PATH];
    SendMessage(pdis->hwndItem, CB_GETLBTEXT, pdis->itemID, (LPARAM)szText);
    
    SetBkMode(hdc, TRANSPARENT);
    SetTextColor(hdc, textCol);
    
    RECT rcText = rc;
    rcText.left += 5; 
    DrawText(hdc, szText, -1, &rcText, DT_SINGLELINE | DT_VCENTER);

    // 4. Upratovanie
    SelectObject(hdc, hOldBrush);
    SelectObject(hdc, hOldPen);
    DeleteObject(hBrush);
    DeleteObject(hPen);
}


//***************************************************************************************************************************************
//**************************************** POPIS TRUKTRY DRAWITEMSTRUCT ***************************************************************
//***************************************************************************************************************************************

/*

typedef struct tagDRAWITEMSTRUCT {
  UINT      CtlType;       // 1. Typ ovldacieho prvku
  UINT      CtlID;         // 2. ID ovldacieho prvku
  UINT      itemID;        // 3. Index poloky (pre ListBox/ComboBox)
  UINT      itemAction;    // 4. Ak typ kreslenia sa vyaduje
  UINT      itemState;     // 5. Aktulny stav (stlaen, neaktvne, fokus...)
  HWND      hwndItem;      // 6. Handle (HWND) samotnho prvku
  HDC       hDC;           // 7. Kontext zariadenia (pltno na kreslenie)
  RECT      rcItem;        // 8. Obdnik definujci hranice prvku
  ULONG_PTR itemData;      // 9. Pouvatesk dta
} DRAWITEMSTRUCT, *PDRAWITEMSTRUCT, *LPDRAWITEMSTRUCT;


---

### Detailn popis poloiek:

#### 1. `CtlType`

Uruje, o ak druh prvku ide.

* `ODT_BUTTON`  Tlaidlo (v prpad).
* `ODT_COMBOBOX`  ComboBox.
* `ODT_LISTBOX`  ListBox.
* `ODT_MENU`  Menu poloka.

#### 2. `CtlID`

ID ovldacieho prvku (napr. `IDC_BUTTON_DCB`), ktor ste mu priradili v resource editore alebo pri `CreateWindowEx`.

#### 3. `itemID`

Pre tlaidl sa nepouva. Pre ListBox alebo ComboBox tu njdete index poloky, ktor systm prve potrebuje vykresli.

#### 4. `itemAction`

Hovor vm, **preo** systm vol prekreslenie:

* `ODA_DRAWENTIRE`  Muste prekresli cel prvok.
* `ODA_FOCUS`  Prvok zskal alebo stratil fokus (bodkovan rmek).
* `ODA_SELECT`  Zmenil sa stav vberu (tlaidlo bolo stlaen).

#### 5. `itemState`

Pravdepodobne najdleitejia poloka. Ide o bitov prznaky (mu by kombinovan pomocou `&`):

* `ODS_SELECTED`  Prvok je stlaen/vybran.
* `ODS_DISABLED`  Prvok je neaktvny (vypnut cez `EnableWindow`).
* `ODS_FOCUS`  Prvok m klvesnicov fokus.
* `ODS_GRAYED`  Poloka by mala by zaednut (pouva sa najm v menu).

#### 6. `hwndItem`

Handle na samotn ovldac prvok. Mete ho poui naprklad na zskanie textu pomocou `GetWindowText`.

#### 7. `hDC`

Handle na kontext zariadenia. Vetky kresliace funkcie ako `RoundRect`, `FillRect` alebo `DrawText` 
vyaduj tento handle ako prv parameter.

#### 8. `rcItem`

truktra `RECT`, ktor hovor, ak vek je tlaidlo. **Pozor:** Sradnice s relatvne k avmu hornmu 
rohu samotnho tlaidla (teda `left` a `top` s vinou 0).

#### 9. `itemData`

Hodnota, ktor mete k poloke priradi vy (napr. cez `CB_SETITEMDATA` pri ComboBoxe). asto sa tu uklad 
smernk na nejak v vlastn objekt alebo truktru s dtami.
//*/














/*
void Vlastne_Tlacitko(LPARAM lParam, int ID_Tlacitka, COLORREF Farba, COLORREF Farba_stlaceneho, COLORREF Farba_pisma)
{
    LPDRAWITEMSTRUCT pdis = (LPDRAWITEMSTRUCT)lParam;
        
    if (pdis->CtlID == ID_Tlacitka)
    {
        HDC hdc = pdis->hDC;
        RECT rc = pdis->rcItem;

        // --- OPRAVA ROHOV PRE TEXTRU ---
        // 1. Nastavme pvod (offset) tetca tak, aby textra v tlaidle 
        // nadvzovala na textru v pozad okna.
        POINT pt = {0, 0};
        MapWindowPoints(pdis->hwndItem, GetParent(pdis->hwndItem), &pt, 1);
        SetBrushOrgEx(hdc, -pt.x, -pt.y, NULL);

        // 2. Vyplnme cel plochu tlaidla textrou okna (hTexturaBrush mus by globlna)
        FillRect(hdc, &rc, hTexturaBrush);
        // --------------------------------

        // 3. Prprava farieb pre samotn tlaidlo
        HBRUSH hBrush = CreateSolidBrush((pdis->itemState & ODS_SELECTED) ? Farba_stlaceneho : Farba);
        HPEN hPen = CreatePen(PS_SOLID, 1, RGB(0, 0, 0));
        
        HBRUSH hOldBrush = (HBRUSH)SelectObject(hdc, hBrush);
        HPEN hOldPen = (HPEN)SelectObject(hdc, hPen);

        // 4. Nakreslme zaoblen obdnik
        // Tm, e sme predtm urobili FillRect s textrou, v rohoch ostane kovov vzor
        RoundRect(hdc, rc.left, rc.top, rc.right, rc.bottom, 15, 15);

        // 5. Text
        TCHAR szText[MAX_PATH];
        GetWindowText(pdis->hwndItem, szText, MAX_PATH);
        SetBkMode(hdc, TRANSPARENT);
        SetTextColor(hdc, Farba_pisma);
        DrawText(hdc, szText, -1, &rc, DT_CENTER | DT_VCENTER | DT_SINGLELINE);

        // Upratovanie
        SelectObject(hdc, hOldBrush);
        SelectObject(hdc, hOldPen);
        DeleteObject(hBrush);
        DeleteObject(hPen);
    }
}
//*/




/*
void Vlastne_Tlacitko(LPARAM lParam, int ID_Tlacitka, COLORREF Farba, COLORREF Farba_stlaceneho, COLORREF Farba_pisma)
{
    LPDRAWITEMSTRUCT pdis = (LPDRAWITEMSTRUCT)lParam;
        
    if (pdis->CtlID == ID_Tlacitka)
    {
        HDC hdc = pdis->hDC;
        RECT rc = pdis->rcItem;

        // 1. Prprava farieb a tetcov
        HBRUSH hBrush;
        if (pdis->itemState & ODS_SELECTED)
            hBrush = CreateSolidBrush(Farba_stlaceneho);
        else
            hBrush = CreateSolidBrush(Farba);

        // Vytvorme pero pre okraj (ierne), aby aj okraj bol zaoblen
        HPEN hPen = CreatePen(PS_SOLID, 1, RGB(0, 0, 0));
        
        // Vyberieme tetec a pero do kontextu zariadenia (HDC)
        HBRUSH hOldBrush = (HBRUSH)SelectObject(hdc, hBrush);
        HPEN hOldPen = (HPEN)SelectObject(hdc, hPen);

        // 2. Nakreslme zaoblen obdnik
        // Posledn dva parametre (15, 15) uruj mieru zaoblenia (rka a vka elipsy rohu)
        RoundRect(hdc, rc.left, rc.top, rc.right, rc.bottom, 15, 15);

        // 3. Napeme text
        TCHAR szText[MAX_PATH];
        GetWindowText(pdis->hwndItem, szText, MAX_PATH);
        
        SetBkMode(hdc, TRANSPARENT);
        SetTextColor(hdc, Farba_pisma);
        
        DrawText(hdc, szText, -1, &rc, DT_CENTER | DT_VCENTER | DT_SINGLELINE);

        // 4. Upratovanie (Dleit!)
        SelectObject(hdc, hOldBrush);
        SelectObject(hdc, hOldPen);
        DeleteObject(hBrush);
        DeleteObject(hPen);
    }
}
//*/




/*
Vlastne_Tlacitko(LPARAM lParam, int ID_Tlacitka, COLORREF Farba, COLORREF Farba_stlaceneho, COLORREF Farba_pisma)
{

	LPDRAWITEMSTRUCT pdis = (LPDRAWITEMSTRUCT)lParam;
		    
	if (pdis->CtlID == ID_Tlacitka) // ID vho tlaidla
	{
		// 1. Vyberieme farbu poda toho, i je tlaidlo stlaen
		HBRUSH hBrush;
		if (pdis->itemState & ODS_SELECTED)
		    hBrush = CreateSolidBrush(Farba_stlaceneho); // Tmavia zelen pri kliknut
		else
		    hBrush = CreateSolidBrush(Farba); // Jasn zelen
		
		// 2. Nakreslme pozadie
		FillRect(pdis->hDC, &pdis->rcItem, hBrush);
		
		// 3. Nakreslme rmek (okraj)
		FrameRect(pdis->hDC, &pdis->rcItem, (HBRUSH)GetStockObject(BLACK_BRUSH));
		
		// 4. Napeme text
		TCHAR szText[MAX_PATH];
		GetWindowText(pdis->hwndItem, szText, MAX_PATH);
		SetBkMode(pdis->hDC, TRANSPARENT);
		SetTextColor(pdis->hDC, Farba_pisma); // Biely text
		
		DrawText(pdis->hDC, szText, -1, &pdis->rcItem, DT_CENTER | DT_VCENTER | DT_SINGLELINE);
		
		DeleteObject(hBrush);
	}

}
//*/


//=======================================================================================================================================
//================================================== FUNKCIE RS232 ======================================================================
//=======================================================================================================================================



// Vyhlada cisla aktivnych COM portov.
int SearchCom(int cislo_portu)
{	
	HANDLE Handle;
	char MenoComu[20];
	BOOL existencia_COM = 0;
	ZeroMemory(&MenoComu, sizeof(MenoComu));
	
	sprintf(MenoComu,"\\\\.\\COM%d", cislo_portu);
	
	Handle = CreateFile(MenoComu,
						   GENERIC_READ|GENERIC_WRITE,
			               0,
						   0,
						   OPEN_EXISTING,
						   0,
						   0);
					

	if (Handle != INVALID_HANDLE_VALUE) 
    {	// Port existuje a je von
        existencia_COM = 1;
        CloseHandle(Handle);
    }
    else 
	{	// Port sa nepodarilo otvori, zisujeme preo
    	DWORD chyba = GetLastError();
        if (chyba == ERROR_ACCESS_DENIED)
			// PORT EXISTUJE, ale je obsaden inm programom
            existencia_COM = -1; 
        else 
            // In chyba (napr. ERROR_FILE_NOT_FOUND) - port nie je v PC
            existencia_COM = 0;
	}
	return existencia_COM;
}




int	Hladanie_com_portov(HWND hwnd)
{	int n, f;
	char MenoComu[20];
	SecureZeroMemory(&MenoComu, sizeof(MenoComu));
	SecureZeroMemory(&AktivnePorty, sizeof(AktivnePorty));
	// Hadanie
	n = 0;
	for(f = 1; f < 64; f++) // Sksme a do 255
	{	if(SearchCom(f))
	    {	AktivnePorty[n] = f;
	        n++;
	    }
	}
	//Ak sa poet portov nezmenil, ComboBox portov sa neaktualizuje (lebo funkcia be v Timeri).
	if ((n > 0) && (n != predosly_pocet_portov))
	{	//Aktivuje Combo vberu portu
    	EnableWindow(GetDlgItem(hwnd, ID_COMBO_PORT_SELECT), TRUE);
		// Vymazanie starch zznamov z Comboboxu
		SendDlgItemMessage(hwnd, ID_COMBO_PORT_SELECT, CB_RESETCONTENT, 0, 0);
		// Pridanie novch zznamov
		for(f = 0; f < n; f++)
		{	sprintf(MenoComu, " COM %d", AktivnePorty[f]);
		    SendDlgItemMessage(hwnd, ID_COMBO_PORT_SELECT, CB_ADDSTRING, 0, (LPARAM)MenoComu);
		}
		// Nastavenie poslednho (ak nejak s)
		//SendDlgItemMessage(hwnd, ID_COMBO_PORT_SELECT, CB_SETCURSEL, (n-1), 0);
		SendDlgItemMessage(hwnd, ID_COMBO_PORT_SELECT, CB_SETCURSEL, posledny_pripojeny_port, 0);
	}
	if(!n)
	{	// Vymazanie starch zznamov z Comboboxu vberu portu
		SendDlgItemMessage(hwnd, ID_COMBO_PORT_SELECT, CB_RESETCONTENT, 0, 0);
		//Vloenie oznamu "NULL" na nult pozciu
		SendDlgItemMessage(hwnd, ID_COMBO_PORT_SELECT, CB_ADDSTRING, 0, (LPARAM)" NULL");
		//Zvolenie nultej pozcie, aby bola viditen hlka "NULL"
		SendDlgItemMessage(hwnd, ID_COMBO_PORT_SELECT, CB_SETCURSEL, 0, 0);	//zvolenie aktualnej polozky
		// Deaktivcia Comboboxu voby portu
		EnableWindow(GetDlgItem(hwnd, ID_COMBO_PORT_SELECT), FALSE);
	} 
	predosly_pocet_portov = n;
	return n;
}







bool Nastavenie_DCB_struktury(HWND hwnd)
{
		int Baud, bit, stop_bit, parita;
	
	    // Defincia vetkch podporovanch rchlost v porad, v akom s v ComboBoxe
	    static const int Rychlosti[] = { 
	        75, 110, 150, 300, 600, 1200, 1800, 2400, 4800, 
	        7200, 9600, 14400, 19200, 38400, 57600, 115200, 128000, 256000 
	    };
	    // Zskanie indexu
	    int index = (int)SendDlgItemMessage(hwnd, ID_COMBO_BAUDRATE, CB_GETCURSEL, 0, 0);
	    // Ochrana proti indexu mimo rozsahu (napr. ak nie je ni vybran)
	    if (index < 0 || index >= (sizeof(Rychlosti) / sizeof(Rychlosti[0])))
	        Baud = 9600; // Predvolen hodnota pri chybe
		else 
			Baud = Rychlosti[index];
		//bitova dlzka
		if(IsDlgButtonChecked(hwnd, ID_RADIO_DATABITY_5) == BST_CHECKED)		bit = 5;
		if(IsDlgButtonChecked(hwnd, ID_RADIO_DATABITY_6) == BST_CHECKED)		bit = 6;
		if(IsDlgButtonChecked(hwnd, ID_RADIO_DATABITY_7) == BST_CHECKED)		bit = 7;
		if(IsDlgButtonChecked(hwnd, ID_RADIO_DATABITY_8) == BST_CHECKED)		bit = 8;
		//stop bit
		if(IsDlgButtonChecked(hwnd, ID_RADIO_STOPBIT_1) == BST_CHECKED)			stop_bit = ONESTOPBIT;
		if(IsDlgButtonChecked(hwnd, ID_RADIO_STOPBIT_1_5) == BST_CHECKED)		stop_bit = ONE5STOPBITS;
		if(IsDlgButtonChecked(hwnd, ID_RADIO_STOPBIT_2) == BST_CHECKED)			stop_bit = TWOSTOPBITS;
		//parita
		if(IsDlgButtonChecked(hwnd, ID_RADIO_BEZ_PARITY) == BST_CHECKED)		parita = NOPARITY;
		if(IsDlgButtonChecked(hwnd, ID_RADIO_NEPARNA_PARITA) == BST_CHECKED)	parita = ODDPARITY;
		if(IsDlgButtonChecked(hwnd, ID_RADIO_PARNA_PARITA) == BST_CHECKED)		parita = EVENPARITY;
		if(IsDlgButtonChecked(hwnd, ID_RADIO_JEDNOTKOVA_PARITA) == BST_CHECKED)	parita = MARKPARITY;
		if(IsDlgButtonChecked(hwnd, ID_RADIO_NULOVA_PARITA) == BST_CHECKED)		parita = SPACEPARITY;
		
		// Deklarcia a plne prvotn vyistenie (iba ak je dcb loklna premenn)
		SecureZeroMemory(&dcb, sizeof(DCB)); 
		dcb.DCBlength = sizeof(DCB); 
		
		// / Funkcia GetCommState napln cel truktru dcb aktulnymi hodnotami priamo z ovldaa.
		if (!GetCommState(ComHandle, &dcb)) 
		    return FALSE; 
		// Nastavenie parametrov
		dcb.BaudRate = Baud;
		dcb.ByteSize = bit;
		dcb.Parity   = parita;
		dcb.StopBits = stop_bit;
		// Doplnkov logika pre fParity (Windows vyaduje zapnutie kontroly, ak je parita nastaven)
		dcb.fParity = (parita == NOPARITY) ? FALSE : TRUE;
		// 4. Odoslanie zmien sp do portu
		if (!SetCommState(ComHandle, &dcb)) 
		    return FALSE;
			
		return TRUE;							
}







// Otvor COM port
bool OpenCom(HWND hwnd, int CisloComu)
{
	char MenoComu[20];
	BOOL StatusDCB = 0;
	CloseHandle(ComHandle);
	sprintf(MenoComu,"\\\\.\\COM%d",CisloComu);
						   
	ComHandle = CreateFile(MenoComu,
							GENERIC_READ | GENERIC_WRITE, 
							0,//FILE_SHARE_READ | FILE_SHARE_WRITE, 
							NULL, 
							OPEN_EXISTING, 
							FILE_FLAG_OVERLAPPED,//Asynchrnny prstup k portu.    | FILE_ATTRIBUTE_NORMAL,//0,//FILE_ATTRIBUTE_NORMAL,
							NULL);
					
	COMMTIMEOUTS timeouts = { 0 };
	timeouts.ReadIntervalTimeout = 50;
	timeouts.ReadTotalTimeoutConstant = 50;
	timeouts.ReadTotalTimeoutMultiplier = 10;
	timeouts.WriteTotalTimeoutConstant = 50;
	timeouts.WriteTotalTimeoutMultiplier = 10;
	SetCommTimeouts(ComHandle, &timeouts);
	
	SecureZeroMemory(&osRead, sizeof(osRead));
	SecureZeroMemory(&osWrite, sizeof(osWrite));
	
	// PRIDAN: Vytvorenie udalost pre asynchrnne I/O
    osRead.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
    osWrite.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);

    if (osRead.hEvent == NULL || osWrite.hEvent == NULL) 
	{
        MessageBox(hwnd, "Chyba pri vytvran udalost.", "Chyba", MB_OK);
        return false;	
	}
		
	if(!SetupComm(ComHandle, 4096, 4096))
	{	MessageBox(hwnd, "Ned sa nastavi vekos bufferov.", "Chyba", MB_OK | MB_ICONSTOP);
		return (0);
	}
	if(!PurgeComm(ComHandle, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR))
	{	MessageBox(hwnd, "Nedaj sa vyprzdni buffery.", "Chyba", MB_OK | MB_ICONSTOP);
		return (0);
	}					
											
	if(ComHandle==INVALID_HANDLE_VALUE) 
	{	MessageBox(hwnd, "COM port sa ned otvori.", "Chyba", MB_OK | MB_ICONINFORMATION);
		return (0);
	}
	else 
	{	StatusDCB = Nastavenie_DCB_struktury(hwnd);
		return StatusDCB;
	}	
	
}

/*================= POZNMNKY =======================
BuildCommDCB("baud, parity, data, stop", &dcb);

dcb.BaudRate
		CBR_110, 
		CBR_300, 
		CBR_600, 
		CBR_1200, 
		CBR_2400, 
		CBR_4800, 
		CBR_9600, 
		CBR_14400, 
		CBR_19200, 
		CBR_38400, 
		CBR_57600, 
		CBR_115200, 
		CBR_128000, 
		CBR_256000,
		
dcb.Parity
		NOPARITY  bez paritnho bitu		0	n
		ODDPARITY  neparna parita			1	o
		EVENPARITY  parna parita			2	e
		MARKPARITY  jednikov parita		3	m
		SPACEPARITY  nulov parita			4	s

dcb.ByteSize
		1 - 255,

dcb.StopBit
		ONESTOPBIT  1 stop bit				0	1
		ONE5STOPBITS  1.5 stop bit		1	1.5
		TWOSTOPBITS  2 stop bit			2	2
				
dcb.fRtsControl
		RTS_CONTROL_DISABLE  vypne			0x00
		RTS_CONTROL_ENABLE  zapne			0x01
		RTS_CONTROL_HANDSHAKE  zapn/vypn auto. podle zaplnn vstupnho bufferu	0x02
		RTS_CONTROL_TOGGLE  zapne pouze pi odesln dat								0x03
		
//*/









// Zatvorenie portu a udalostii, vynulovanie masky, vycistenie bufferov.
void CloseCom()
{	PurgeComm(ComHandle,PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);
	SetCommMask(ComHandle,0);
	CloseHandle(ComHandle);
	ComHandle = NULL;
	CloseHandle(osRead.hEvent);
	CloseHandle(osWrite.hEvent);
	SuspendThread(ghThread);
}






void DeaktivaciaRadioButtonov(HWND hwnd)
{
	int f;
	//Deaktivuje radiobuttony Datovych bitov
	for(f = 0; f < 4; f++)
		EnableWindow(GetDlgItem(hwnd, (ID_RADIO_DATABITY_5 + f)), FALSE); 
	//Deaktivuje radiobuttony Parity
	for(f = 0; f < 5; f++)
		EnableWindow(GetDlgItem(hwnd, (ID_RADIO_BEZ_PARITY + f)), FALSE); 
	//Deaktivuje radiobuttony StopBitu
	for(f = 0; f < 3; f++)
		EnableWindow(GetDlgItem(hwnd, (ID_RADIO_STOPBIT_1 + f)), FALSE); 
	EnableWindow(GetDlgItem(hwnd, ID_RADIO_ASCII), FALSE);
    EnableWindow(GetDlgItem(hwnd, ID_RADIO_NUMBER), FALSE);
	EnableWindow(GetDlgItem(hwnd, ID_COMBO_BAUDRATE), FALSE);
    //EnableWindow(GetDlgItem(hwnd, ID_COMBO_PORT_SELECT), FALSE);
				

}





void AktivaciaRadioButtonov(HWND hwnd)
{	int f, aktivny_port;
	//Aktivuje radiobuttony Datovych bitov
	for(f = 0; f < 4; f++)
		EnableWindow(GetDlgItem(hwnd, (ID_RADIO_DATABITY_5 + f)), TRUE); 
	//Aktivuje radiobuttony Parity
	for(f = 0; f < 5; f++)
		EnableWindow(GetDlgItem(hwnd, (ID_RADIO_BEZ_PARITY + f)), TRUE); 
	//Aktivuje radiobuttony StopBitu
	for(f = 0; f < 3; f++)
		EnableWindow(GetDlgItem(hwnd, (ID_RADIO_STOPBIT_1 + f)), TRUE); 				
	EnableWindow(GetDlgItem(hwnd, ID_RADIO_ASCII), TRUE);
    EnableWindow(GetDlgItem(hwnd, ID_RADIO_NUMBER), TRUE);
	EnableWindow(GetDlgItem(hwnd, ID_COMBO_BAUDRATE), TRUE);
    //EnableWindow(GetDlgItem(hwnd, ID_COMBO_PORT_SELECT), TRUE);
	
	//AK je zaskrknuty RadioButton DataBit = 5; deaktivuje sa RadioButton 2 stopbit
	//...V opacnom pripade sa deaktivuje RadioButton 1.5 stopbitu
	if(IsDlgButtonChecked(hwnd, ID_RADIO_DATABITY_5) == BST_CHECKED)	
    	EnableWindow(GetDlgItem(hwnd, ID_RADIO_STOPBIT_2), FALSE); 	
	else
		EnableWindow(GetDlgItem(hwnd, ID_RADIO_STOPBIT_1_5), FALSE);
}






//***********************************************************************************
//*************************** FUNKCIE PRE PRACU S REGISTRAMI ************************
//***********************************************************************************



//otvorenie kluca v registroch. 
//Navratova hodnota funkcie je handle vytvoreneho kluca.
//"lpKeyName" = meno a cesta podkluca, ktory sa ma oTvorit al. vytvorit.
//Ak nastavime "lpbCreated" = TRUE, vrati TRUE, ak kluc neexistoval, a bol vytvoreny. Inak vrati NULL.
HKEY registry_OpenKey(LPCTSTR lpKeyName, LPBOOL lpbCreated)
{   DWORD dwDisp = 0;
    HKEY hkResult = NULL;
    if(RegCreateKeyEx(HKEY_CURRENT_USER, // handle existujuceho kluca v registroch (aktualny pouzivatel)
                      lpKeyName, //meno podkluca = vytvorenie vlastnej polozky v registroch, ktora bude stromovo zaradena pod "HKEY_CURRENT_USER".
                      0,  //tento parameter je rezervovany, a musi byt nula.
                      NULL,  //uzivatelom definovana trieda kluca
                      REG_OPTION_NON_VOLATILE, // nastavenia. REG_OPTION_NON_VOLATILE = ulozene hodnoty su zachovane aj po restarte PC. REG_OPTION_NON_VOLATILE = ulozene hodnoty su odstranene po restarte PC.
                      KEY_ALL_ACCESS, // maska, ktora urcuje pristupove prava pre kluce, ktore maju byt otvorene.
                      NULL, // ukazatel na strukturu "SECURITY_ATTRIBUTES" ktora urcuje, ci navratove handle moze byt dedene podriadenymi procesmi. NULL=handle nemozno dedit.
                      &hkResult, // ukazovatel na premennu, ktora obdrzi handle otvoreneho (existujuceho) al. vytvoreneho kluca.
                      &dwDisp) // ukazovatel na premennu, ktora dostane jednu z nasledujucichhodnot:...
                               // REG_CREATED_NEW_KEY = kluc neexistoval a bol vytvoreny
                               // REG_OPENED_EXISTING_KEY = kluc existoval, a bol len otvoreny
                               // NULL = niesu vratene ziadne informacie
       != ERROR_SUCCESS)   //navratova hodnota: ak funkcia uspeje, vrati ERROR_SUCCESS. V pripade chyby vrati kod chyby, ktore su definovane vo Winerror.h
       return NULL;
    //Ak na vstupe funkcie nastavim lpbCreated = TRUE, premenna vrati TRUE, ak kluc...
    //...neexistoval, a bol vytvoreny. V ostatnych pripadoch vrati NULL. (premenna je pointer)
    if (lpbCreated)
       *lpbCreated = (dwDisp == REG_CREATED_NEW_KEY);
    //funkcia vracia handle vytvoreneho kluca.   
    return hkResult;
}



//vytvorenie datovej hodnoty typu DWORD v kluci (polozke) registra.
BOOL registry_WriteBYTE(HKEY hKey, LPCTSTR lpValueName, BYTE bValue)
{   return (RegSetValueEx(hKey, //handle mnou vytvoreneho al. uz existujuceho kluca (spristupneneho na zapis).
                          lpValueName,  // nazov hodnoty, ktorym ju chcem nazvat. Ak je NULL alebo "", funkcia nastavi nazov na predvolenu hodnotu.
                          0,  //tento parameter je rezervovany, a musi byt nula.
                          REG_BINARY, // typ hodnoty. napr.: REG_DWORD (32bit) REG_BINARY, REG_NONE (bez definovania typu), REG_QWORD (64bit), atd...
                          (CONST BYTE*)&bValue, //pointer na premennu, v ktorej je hodnota, ktora ma byt ulozena do registra.
                          sizeof(BYTE)) // velkost ukladanej hodnoty (premennej) v bajtoch.
            == ERROR_SUCCESS);  //navratova hodnota: ak funkcia uspeje, vrati ERROR_SUCCESS. V pripade chyby vrati kod chyby, ktore su definovane vo Winerror.h
}



//vytvorenie datovej hodnoty typu DWORD v kluci (polozke) registra.
BOOL registry_WriteDWORD(HKEY hKey, LPCTSTR lpValueName, DWORD dwValue)
{   return (RegSetValueEx(hKey, //handle mnou vytvoreneho al. uz existujuceho kluca (spristupneneho na zapis).
                          lpValueName,  // nazov hodnoty, ktorym ju chcem nazvat. Ak je NULL alebo "", funkcia nastavi nazov na predvolenu hodnotu.
                          0,  //tento parameter je rezervovany, a musi byt nula.
                          REG_DWORD, // typ hodnoty. napr.: REG_DWORD (32bit) REG_BINARY, REG_NONE (bez definovania typu), REG_QWORD (64bit), atd...
                          (CONST BYTE*)&dwValue, //pointer na premennu, v ktorej je hodnota, ktora ma byt ulozena do registra.
                          sizeof(DWORD)) // velkost ukladanej hodnoty (premennej) v bajtoch.
            == ERROR_SUCCESS);  //navratova hodnota: ak funkcia uspeje, vrati ERROR_SUCCESS. V pripade chyby vrati kod chyby, ktore su definovane vo Winerror.h
}



//univerzalna funkcia na vytvorenie datovej hodnoty typu STRING v kluci (polozke) registra.
BOOL registry_WriteString(HKEY hKey, LPCTSTR lpValueName, LPCTSTR lpText)
{   return (RegSetValueEx(hKey, 
                          lpValueName, 
                          0, 
                          REG_SZ, // typ hodnoty. REG_SZ je typ "retazec zakonceny nulou"
                          (CONST BYTE*)lpText, //pointer na pole v ktorom su ulozene textove udaje, zakoncene nulou, ktore maju byt ulozene do registra.
                          (lstrlen(lpText)+1)*sizeof(TCHAR)) // velkost ukladanej hodnoty v bajtoch. ...lstrlen = dlzka textu * sizeof = dlzka datoveho typu textu v bajtoch. Cize celkovo dlzka textu v bajtoch. (1bajt = 8bitov)
            == ERROR_SUCCESS);
}


BOOL registry_ReadBYTE(HKEY hKey, LPCTSTR lpValueName, LPBYTE lpBResult)
{   DWORD dwValue = 0,
		  bSize = sizeof(BYTE), 
		  bType = 0;
    if ( RegQueryValueEx(hKey, //handle mnou vytvoreneho al. uz existujuceho kluca (spristupneneho na zapis).
                         lpValueName, // nazov hodnoty, ktoru chcem nacitat. Ak nazov urcuje hodnotu ktora nieje v registri, funkcia vrati ERROR_FILE_NOT_FOUND. -Ak zadam NULL alebo "", funkcia nacita nemenovane al. predvolene hodnoty.
                         NULL, //tento parameter je rezervovany, a musi byt nula.
                         &bType, // typ hodnoty ktoru chcem nacitat. napr.: REG_DWORD (32bit) REG_BINARY, REG_NONE (bez definovania typu), REG_QWORD (64bit), atd...
                         (LPBYTE)&dwValue, //ukazovatel na premennu/pole/vyrovnavaciu pamat, do ktorej sa ulozi hodnota al. data.
                         &bSize) //ukazovatel na premennu, v ktorej je zapisana velkost vyrovnavacej pamate/pola/premennej v bajtoch, kam sa uklada hodnota. -Ak pamat nieje dostatocne velka, funkcia vrati ERROR_MORE_DATA.
       != ERROR_SUCCESS )   //navratova hodnota: ak funkcia uspeje, vrati ERROR_SUCCESS. V pripade chyby vrati kod chyby, ktore su definovane vo Winerror.h
       return FALSE;
    *lpBResult = dwValue;
    return TRUE;
}



//citanie datovej hodnoty typu DWORD z kluca registra.
BOOL registry_ReadDWORD(HKEY hKey, LPCTSTR lpValueName, LPDWORD lpdwResult)
{   DWORD dwValue = 0,
		  dwSize = sizeof(DWORD), 
		  dwType = 0;
    if ( RegQueryValueEx(hKey, //handle mnou vytvoreneho al. uz existujuceho kluca (spristupneneho na zapis).
                         lpValueName, // nazov hodnoty, ktoru chcem nacitat. Ak nazov urcuje hodnotu ktora nieje v registri, funkcia vrati ERROR_FILE_NOT_FOUND. -Ak zadam NULL alebo "", funkcia nacita nemenovane al. predvolene hodnoty.
                         NULL, //tento parameter je rezervovany, a musi byt nula.
                         &dwType, // typ hodnoty ktoru chcem nacitat. napr.: REG_DWORD (32bit) REG_BINARY, REG_NONE (bez definovania typu), REG_QWORD (64bit), atd...
                         (LPBYTE)&dwValue, //ukazovatel na premennu/pole/vyrovnavaciu pamat, do ktorej sa ulozi hodnota al. data.
                         &dwSize) //ukazovatel na premennu, v ktorej je zapisana velkost vyrovnavacej pamate/pola/premennej v bajtoch, kam sa uklada hodnota. -Ak pamat nieje dostatocne velka, funkcia vrati ERROR_MORE_DATA.
       != ERROR_SUCCESS )   //navratova hodnota: ak funkcia uspeje, vrati ERROR_SUCCESS. V pripade chyby vrati kod chyby, ktore su definovane vo Winerror.h
       return FALSE;
    *lpdwResult = dwValue;
    return TRUE;
}



//univerzalna funkcia na citanie datovej hodnoty typu STRING z kluca registra.
BOOL registry_ReadString(HKEY hKey, LPCTSTR lpValueName, LPTSTR lpString, DWORD dwBufferSize)
{
    DWORD dwType = 0;
    DWORD dwSize = dwBufferSize; 

    if (RegQueryValueEx(hKey, 
                        lpValueName, 
                        NULL, 
                        &dwType, 
                        (LPBYTE)lpString, 
                        &dwSize) != ERROR_SUCCESS)
        return FALSE;

    // Voliten: Overenie, i ide o reazec
    if (dwType != REG_SZ && dwType != REG_EXPAND_SZ)
    	return FALSE;
	
    return TRUE;
}



BOOL registry_CloseKey(HKEY &hKey) // Pouitie referencie (v C++)
{
    if (hKey == NULL) 
		return TRUE;
    LSTATUS status = RegCloseKey(hKey);
    hKey = NULL; // Zabezpeme, e sa handle nepouije znova
    return (status == ERROR_SUCCESS);
}


//*********************************** ZAPIS/CITANIE REGISTROV ********************************



BOOL WriteRegistry(HWND hwnd)
{   
	RECT rectDSKTP;
	HWND hwndDSKTP = GetDesktopWindow();
	GetClientRect(hwndDSKTP, &rectDSKTP);
	
	WINDOWPLACEMENT wp;
    wp.length = sizeof(WINDOWPLACEMENT);
    //Naplni polozky struktury WINDOWPLACEMENT aktualnym stavom, rozmermi, atd, hl. okna.
    GetWindowPlacement(hwnd, &wp);
    //struktura obdlznika, ktora obsahuje polozky pre polohu laveho horneho...
    //...a praveho dolneho rohu obdlznika.
    RECT rect;
    //naplni strukturu rozmermi okna
    GetWindowRect(hwnd, &rect);
    // Osetrenie, ked je lavy horny roh okna za rohom obrazovky. 
    //Vdaka tomu sa do registra sa ulozi hodnota minimalne 0.
    if(rect.left < 0)
    {  rect.right -= rect.left;
       rect.left = 0;             
    }
    if(rect.top < 0)
    {  rect.bottom -= rect.top;
       rect.top = 0;
    }
    if(rect.bottom > rectDSKTP.bottom)
    {	rect.top -= (rect.bottom - rectDSKTP.bottom);
		rect.bottom = rectDSKTP.bottom;
    }
    if(rect.right > rectDSKTP.right)
    {	rect.left -= (rect.right - rectDSKTP.right);
    	rect.right = rectDSKTP.right;
    }
    // Zo struktury WINDOWPLACEMENT sa do premennej registra ulozi udaj o stave okna pred...
    //...jeho zatvorenim. (tj. ci bolo maximalizovane, normalne alebo minimalizovane)
    g_dwWindowShow = wp.showCmd;
    //Udaje o rozmeroch okna sa do registra zapisu len vtedy, ked nebolo pred zatvorenim...
    //...maximalizovane al. minimalizovane. (tj. bolo zobrazene normalne) 
    if(wp.showCmd == SW_SHOWNORMAL)
    {   //MAKELONG zluci suradnice x,y laveho horneho rohu okna do jedinej 32bitovej globalnej...
        //...premennej, ako horny a dolny WORD. Na ich rozdelenie potom treba pouzit LOWORD(),HIWORD().
        g_dwWindowPos = MAKELONG(rect.left, rect.top);
        //MAKELONG zluci sirku a vysku okna do jedinej 32bitovej globalnej premennej, ako horny...
        //...a dolny WORD. Na ich rozdelenie potom treba pouzit LOWORD(),HIWORD().
        g_dwWindowSize = MAKELONG(rect.right-rect.left, rect.bottom-rect.top);
    }
    //Zapis do registrov
	BOOL bRes = TRUE;
    HKEY hKey = registry_OpenKey(REGISTRY_KEY_NAME, NULL);
    if ( !hKey )
       return FALSE;
    if (!registry_WriteDWORD(hKey, TEXT("WindowPos"), g_dwWindowPos))
       bRes = FALSE;
    if (!registry_WriteDWORD(hKey, TEXT("WindowSize"), g_dwWindowSize))
       bRes = FALSE;
    if (!registry_WriteDWORD(hKey, TEXT("WindowShow"), g_dwWindowShow))
       bRes = FALSE;
    if ( !registry_WriteBYTE(hKey, "Baud/s", Aktualna_rychlost))
        bRes = FALSE;     
   	if ( !registry_WriteBYTE(hKey, "Port", posledny_pripojeny_port))
        bRes = FALSE;
   	if ( !registry_WriteBYTE(hKey, "PocetPortov", pocet_portov_pre_ComboBox))
        bRes = FALSE;
    if (!registry_CloseKey(hKey))
       bRes = FALSE;
    return bRes;
}







BOOL ReadRegistry(HWND hwnd)
{   	
	BOOL bRes = TRUE;
    BOOL bFirst = FALSE;
    HKEY hKey;
    if(!(hKey = registry_OpenKey(REGISTRY_KEY_NAME, &bFirst)))
        return FALSE; 
	//Umiestnenie okna pri prvom spusteni do stredu obrazovky
	if (bFirst)
    {   RECT rectDSKTP;
		HWND hwndDSKTP = GetDesktopWindow();
		GetClientRect(hwndDSKTP, &rectDSKTP);
		//RECT rect;
    	//GetWindowRect(hwnd, &rect); // Zist aktulne rozmery okna
    	//GetClientRect(hwnd, &rect); // Zist aktulne rozmery okna
    	//int windowWidth  = rect.right - rect.left;
    	//int windowHeight = rect.bottom - rect.top;
		//int screenWidth  = GetSystemMetrics(SM_CXSCREEN);
	    //int screenHeight = GetSystemMetrics(SM_CYSCREEN);	
    	int windowWidth  = _SirkaHlOkna;
	    int windowHeight = _VyskaHlOkna;
	    int screenWidth  = rectDSKTP.right-rectDSKTP.left;
	    int screenHeight = rectDSKTP.bottom-rectDSKTP.top;
	    int x = (screenWidth - windowWidth)/2;
    	int y = (screenHeight - windowHeight)/2;	
		g_dwWindowPos = MAKELONG(x, y); //x,y. Zlucene do dolneho a horneho wordu.
        g_dwWindowSize = MAKELONG(_SirkaHlOkna, _VyskaHlOkna); //vyska, sirka. Zlucene do dolneho a horneho wordu.
        g_dwWindowShow = 1;
        return TRUE;
	}
    if ( !registry_ReadDWORD(hKey, "WindowPos", &g_dwWindowPos) )
        bRes = FALSE;
    if ( !registry_ReadDWORD(hKey, "WindowSize", &g_dwWindowSize) )
        bRes = FALSE;
    if ( !registry_ReadDWORD(hKey, "WindowShow", &g_dwWindowShow) )
        bRes = FALSE;     
   	if ( !registry_ReadBYTE(hKey, "Baud/s", &Aktualna_rychlost) )
        bRes = FALSE;     
   	if ( !registry_ReadBYTE(hKey, "Port", &posledny_pripojeny_port) )
        bRes = FALSE;
   	if ( !registry_ReadBYTE(hKey, "PocetPortov", &pocet_portov_pre_ComboBox))
        bRes = FALSE;     
    if ( !registry_CloseKey(hKey) )
        bRes = FALSE;
    return bRes;
}



//============================================== PRCA S MYOU ===============================================


POINT PolohaMysiDesktop(HWND hwnd)
{	POINT point; 
    GetCursorPos(&point);
    return point;
}



int AktivitaMysi(HWND hwnd)
{	POINT point; 
	int aktivita = 0;
	POINT stara_poloha;
    GetCursorPos(&point);   
    if((stara_poloha.x != point.x) || (stara_poloha.y != point.y))
    	aktivita = 1;
    stara_poloha.x = point.x;
    stara_poloha.y = point.y;   
    return aktivita;
}



COLORREF FarbaMysiDesktop()
{	POINT point; 
    GetCursorPos(&point);
    HDC hdc = GetDC(NULL);
    return GetPixel(hdc, point.x, point.y);
	ReleaseDC(NULL, hdc);
}



void KlikMysou(int x, int y)
{   SetCursorPos(x, y); //presunutie kurzora mysi na pozadovanu poziciu
    Sleep(20);
    mouse_event(MOUSEEVENTF_LEFTDOWN, 0, 0, 0, 0); //autoklik stlacenia lavym tlacidlom mysi
    Sleep(20);
    mouse_event(MOUSEEVENTF_LEFTUP, 0, 0, 0, 0); //autoklik pustenia laveho tlacidla mysi
    Sleep(20);
}



void KlikanieMysou(int pocet_klikov, int x, int y)
{   int f;
    for(f = 0; f < pocet_klikov; f++)
    {  SetCursorPos(x, y); //presunutie kurzora mysi na pozadovanu poziciu
       Sleep(20);
       mouse_event(MOUSEEVENTF_LEFTDOWN, 0, 0, 0, 0); //autoklik stlacenia lavym tlacidlom mysi
       Sleep(20);
       mouse_event(MOUSEEVENTF_LEFTUP, 0, 0, 0, 0); //autoklik pustenia laveho tlacidla mysi
       Sleep(20);
    }
}



//============================================== PRCA S TEXTOM ===============================================


// Zobrazenie napisu. Volitelne aj s premennou
void Napis(HDC hdc, 
		   SIZE* rozmery, //vrati rozmery textu
		   LPCTSTR text,  //text, alebo text s formatovacim znakom, napr. %d v pripade, ze chcem zobrazit aj premennu.
		   int premenna,  //premenna na zobrazenie.
		   int x, int y,  // umiestnenie textu
		   COLORREF farba_pisma, // farba pisma
		   int velkost_pisma, // velkost pisma. Najlepsie je zadva zporn hodnoty. Velkost sa vtedy zobrazi presne.
		   int pismo_bold, //  1 tun psmo, 0 normlne psmo.
		   int zvisly_text,
		   LPCTSTR typ_pisma) //Nzov typu psma vo forme textu v vodzovkch
{   LOGFONT logFont;
	HFONT hFont, hFontOld;
	COLORREF ColorOld;
	TCHAR zobrazenie[100];
	SetBkMode(hdc, TRANSPARENT);
	ColorOld = SetTextColor(hdc, farba_pisma);
	GetObject(GetStockObject(DEFAULT_GUI_FONT), sizeof(logFont), &logFont); 
	lstrcpy(logFont.lfFaceName, typ_pisma);
	if(velkost_pisma != 0)
		logFont.lfHeight = velkost_pisma;
	if(pismo_bold == 1)
		logFont.lfWeight = 600;
	else
		logFont.lfWeight = 0;
	if(zvisly_text == 1)
		logFont.lfEscapement = 900;
	else
		logFont.lfEscapement = 0;
	hFont = CreateFontIndirect(&logFont);
	hFontOld = (HFONT)SelectObject(hdc, hFont); 
    _stprintf(zobrazenie, text, premenna);
	TextOut(hdc, x, y, zobrazenie, lstrlen(zobrazenie));
	GetTextExtentPoint32(hdc, zobrazenie, lstrlen(zobrazenie), rozmery);
	SelectObject(hdc, hFontOld);
    DeleteObject(hFont);
    SetTextColor(hdc, ColorOld);
}



// Zobrazenie napisu. Volitelne aj s premennou
void NapisDouble(HDC hdc, 
		   SIZE* rozmery, //vrati rozmery textu
		   LPCTSTR text,  //text, alebo text s formatovacim znakom, napr. %d v pripade, ze chcem zobrazit aj premennu.
		   double premenna,  //premenna na zobrazenie.
		   int x, int y,  // umiestnenie textu
		   COLORREF farba_pisma, // farba pisma
		   int velkost_pisma, // velkost pisma. Najlepsie je zadva zporn hodnoty. Velkost sa vtedy zobrazi presne.
		   int pismo_bold, //  1 tun psmo, 0 normlne psmo.
		   LPCTSTR typ_pisma) //Nzov typu psma vo forme textu v vodzovkch
{   LOGFONT logFont;
	HFONT hFont, hFontOld;
	COLORREF ColorOld;
	TCHAR zobrazenie[100];
	SetBkMode(hdc, TRANSPARENT);
	ColorOld = SetTextColor(hdc, farba_pisma);
	GetObject(GetStockObject(DEFAULT_GUI_FONT), sizeof(logFont), &logFont); 
	lstrcpy(logFont.lfFaceName, typ_pisma);
	if(velkost_pisma != 0)
		logFont.lfHeight = velkost_pisma;
	if(pismo_bold == 1)
		logFont.lfWeight = 600;
	else
		logFont.lfWeight = 0;
	hFont = CreateFontIndirect(&logFont);
	hFontOld = (HFONT)SelectObject(hdc, hFont); 
    _stprintf(zobrazenie, text, premenna);
	TextOut(hdc, x, y, zobrazenie, lstrlen(zobrazenie));
	GetTextExtentPoint32(hdc, zobrazenie, lstrlen(zobrazenie), rozmery);
	SelectObject(hdc, hFontOld);
    DeleteObject(hFont);
    SetTextColor(hdc, ColorOld);
}



void NapisFloat(HDC hdc, 
		   SIZE* rozmery, //vrati rozmery textu
		   LPCTSTR text,  //text, alebo text s formatovacim znakom, napr. %d v pripade, ze chcem zobrazit aj premennu.
		   float premenna,  //premenna na zobrazenie.
		   int x, int y,  // umiestnenie textu
		   COLORREF farba_pisma, // farba pisma
		   int velkost_pisma, // velkost pisma. Najlepsie je zadva zporn hodnoty. Velkost sa vtedy zobrazi presne.
		   int pismo_bold, //  1 tun psmo, 0 normlne psmo.
		   LPCTSTR typ_pisma) //Nzov typu psma vo forme textu v vodzovkch
{   LOGFONT logFont;
	HFONT hFont, hFontOld;
	COLORREF ColorOld;
	TCHAR zobrazenie[100];
	SetBkMode(hdc, TRANSPARENT);
	ColorOld = SetTextColor(hdc, farba_pisma);
	GetObject(GetStockObject(DEFAULT_GUI_FONT), sizeof(logFont), &logFont); 
	lstrcpy(logFont.lfFaceName, typ_pisma);
	if(velkost_pisma != 0)
		logFont.lfHeight = velkost_pisma;
	if(pismo_bold == 1)
		logFont.lfWeight = 600;
	else
		logFont.lfWeight = 0;
	hFont = CreateFontIndirect(&logFont);
	hFontOld = (HFONT)SelectObject(hdc, hFont); 
    _stprintf(zobrazenie, text, premenna);
	TextOut(hdc, x, y, zobrazenie, lstrlen(zobrazenie));
	GetTextExtentPoint32(hdc, zobrazenie, lstrlen(zobrazenie), rozmery);
	SelectObject(hdc, hFontOld);
    DeleteObject(hFont);
    SetTextColor(hdc, ColorOld);
}


//============================================== GRAFIKA ===============================================


// Zobrazenie nejakej klavesy alebo textu v modrom okienku   
void Klavesa(HDC hdc, SIZE* rozmery, LPCTSTR text, int zaoblenie, int xx, int yy)
{  	HPEN hPen,hPenOld;
	HBRUSH hBrush, hBrushOld;
	HFONT hFont, hFontOld;
	LOGFONT logFont;
	COLORREF ColorOld;
	SetBkMode(hdc, TRANSPARENT);
	ColorOld = SetTextColor(hdc, RGB(0,70,95));//10,80,105));
	GetObject(GetStockObject(DEFAULT_GUI_FONT), sizeof(logFont), &logFont); 
	lstrcpy(logFont.lfFaceName, "Segoe UI");
	logFont.lfHeight = -12;
	//logFont.lfWeight = 600;
	hFont = CreateFontIndirect(&logFont);
	hPen = CreatePen(PS_SOLID | PS_INSIDEFRAME, 1, RGB(0,190,255));  //0x00FF0000);   
	hBrush = CreateSolidBrush(RGB(150,200,255));  //0x0080FFFF); 
	hFontOld = (HFONT)SelectObject(hdc, hFont);
	hPenOld = (HPEN) SelectObject(hdc, hPen);  
	hBrushOld = (HBRUSH)SelectObject(hdc, hBrush);
	GetTextExtentPoint32(hdc, text, lstrlen(text), rozmery);
	int x = xx + 7,
		y = yy + 2;
	RoundRect(hdc, x-7,y-2, x+7+rozmery->cx,y+2+rozmery->cy, zaoblenie, zaoblenie);
	TextOut(hdc, x, y, text, lstrlen(text));
	SelectObject(hdc, hPenOld);
    SelectObject(hdc, hBrushOld);
    SelectObject(hdc, hFontOld);
    DeleteObject(hBrush);
    DeleteObject(hPen);
    DeleteObject(hFont);
    SetTextColor(hdc, ColorOld);
}



// Zobrazenie nejakej klavesy alebo textu v modrom okienku s moznostou zmeny velkosti  
void KlavesaMala(HDC hdc, SIZE* rozmery, LPCTSTR text, int zaoblenie, int xx, int yy)
{  	HPEN hPen,hPenOld;
	HBRUSH hBrush, hBrushOld;
	HFONT hFont, hFontOld;
	LOGFONT logFont;
	COLORREF ColorOld;
	SetBkMode(hdc, TRANSPARENT);
	ColorOld = SetTextColor(hdc, RGB(0,70,95));//10,80,105));
	GetObject(GetStockObject(DEFAULT_GUI_FONT), sizeof(logFont), &logFont); 
	lstrcpy(logFont.lfFaceName, "Times New Roman");
	//lstrcpy(logFont.lfFaceName, "Arial");
	//lstrcpy(logFont.lfFaceName, "Segoe");
	//lstrcpy(logFont.lfFaceName, "MS Serif");
	//lstrcpy(logFont.lfFaceName, "Tahoma");
	//lstrcpy(logFont.lfFaceName, "Verdana");
	//lstrcpy(logFont.lfFaceName, "Calibri");
	//lstrcpy(logFont.lfFaceName, "Arimo");
	//lstrcpy(logFont.lfFaceName, "Corbel");
	//lstrcpy(logFont.lfFaceName, "Microsoft Sans Serif");
	//lstrcpy(logFont.lfFaceName, "Georgia");
	logFont.lfHeight = -9;
	//logFont.lfWeight = 600;
	hFont = CreateFontIndirect(&logFont);
	hPen = CreatePen(PS_SOLID | PS_INSIDEFRAME, 1, RGB(0,190,255));  //0x00FF0000);   
	hBrush = CreateSolidBrush(RGB(150,200,255));  //0x0080FFFF); 
	hFontOld = (HFONT)SelectObject(hdc, hFont);
	hPenOld = (HPEN) SelectObject(hdc, hPen);  
	hBrushOld = (HBRUSH)SelectObject(hdc, hBrush);
	GetTextExtentPoint32(hdc, text, lstrlen(text), rozmery);
	int x = xx + 7,
		y = yy + 2;
	RoundRect(hdc, x-4,y-1, x+4+rozmery->cx,y+2+rozmery->cy, zaoblenie, zaoblenie);
	TextOut(hdc, x, y, text, lstrlen(text));
	SelectObject(hdc, hPenOld);
    SelectObject(hdc, hBrushOld);
    SelectObject(hdc, hFontOld);
    DeleteObject(hBrush);
    DeleteObject(hPen);
    DeleteObject(hFont);
    SetTextColor(hdc, ColorOld);
}



void SipkaVpravo(HDC hdc, int rozmer, int x, int y)
{   HPEN hPen,hPenOld;
	HBRUSH hBrush, hBrushOld;
	int sipka_X,
		sipka_Y,
		sirka_sipky = 4,
		dlzka_sipky = 7;
	float proporcie_sipky = 1.9;
	hPen = CreatePen(PS_SOLID | PS_INSIDEFRAME, 1, RGB(0,190,255));  //0x00FF0000);   
	hBrush = CreateSolidBrush(RGB(150,200,255));  //0x0080FFFF); 
	hPenOld = (HPEN) SelectObject(hdc, hPen);  
	hBrushOld = (HBRUSH)SelectObject(hdc, hBrush);
	RoundRect(hdc, x, y, x + rozmer, y + rozmer, 8,8);
	DeleteObject(hPen); 
	DeleteObject(hBrush);
	sipka_X = x + (rozmer - proporcie_sipky * dlzka_sipky)/2;
    sipka_Y = y + rozmer/2;
    //definovanie bodov nadvazujucich useciek
	POINT MyPoints[6] = {sipka_X, 								  sipka_Y,
						 sipka_X + dlzka_sipky, 				  sipka_Y,
						 sipka_X + dlzka_sipky, 				  sipka_Y + sirka_sipky,
						 sipka_X + proporcie_sipky * dlzka_sipky, sipka_Y,
						 sipka_X + dlzka_sipky, 				  sipka_Y - sirka_sipky,
						 sipka_X + dlzka_sipky, 				  sipka_Y};
	hBrush = CreateSolidBrush(RGB(80,100,120));  //farba sipky
    hPen = CreatePen(PS_SOLID, 2, RGB(80,100,120));  //farba vyplne sipky
    SelectObject(hdc, hPen);
    SelectObject(hdc, hBrush);
    //Nakresli sadu nadvazujucich useciek, na zaklade definovanych bodov. ...
    //...Cislo 6 udava pocet useciek. Moze byt mensi alebo rovny poctu bodov.
    //Polyline(hdc, MyPoints, 6); //mnohouholnik bez vyplne
    Polygon(hdc, MyPoints, 6); //mnohouholnik s vyplnou  
    SelectObject(hdc, hPenOld);
    SelectObject(hdc, hBrushOld);
    DeleteObject(hBrush);
    DeleteObject(hPen);	
}



void SipkaVlavo(HDC hdc, int rozmer, int x, int y)
{   HPEN hPen,hPenOld;
	HBRUSH hBrush, hBrushOld;
	int sipka_X,
		sipka_Y,
		sirka_sipky = 4,
		dlzka_sipky = 7;
	float proporcie_sipky = 1.9;
	hPen = CreatePen(PS_SOLID | PS_INSIDEFRAME, 1, RGB(0,190,255));  //0x00FF0000);   
	hBrush = CreateSolidBrush(RGB(150,200,255));  //0x0080FFFF); 
	hPenOld = (HPEN) SelectObject(hdc, hPen);  
	hBrushOld = (HBRUSH)SelectObject(hdc, hBrush);
	RoundRect(hdc, x, y, x + rozmer, y + rozmer, 8,8);
	DeleteObject(hPen); 
	DeleteObject(hBrush);
	sipka_X = x + rozmer - (rozmer - proporcie_sipky * dlzka_sipky)/2;
    sipka_Y = y + rozmer/2;
    //definovanie bodov nadvazujucich useciek
	POINT MyPoints[6] = {sipka_X, 								  sipka_Y,
						 sipka_X - dlzka_sipky, 				  sipka_Y,
						 sipka_X - dlzka_sipky, 				  sipka_Y + sirka_sipky,
						 sipka_X - proporcie_sipky * dlzka_sipky, sipka_Y,
						 sipka_X - dlzka_sipky, 				  sipka_Y - sirka_sipky,
						 sipka_X - dlzka_sipky, 				  sipka_Y};
	hBrush = CreateSolidBrush(RGB(80,100,120));  //farba sipky
    hPen = CreatePen(PS_SOLID, 2, RGB(80,100,120));  //farba vyplne sipky
    SelectObject(hdc, hPen);
    SelectObject(hdc, hBrush);
    //Nakresli sadu nadvazujucich useciek, na zaklade definovanych bodov. ...
    //...Cislo 6 udava pocet useciek. Moze byt mensi alebo rovny poctu bodov.
    //Polyline(hdc, MyPoints, 6); //mnohouholnik bez vyplne
    Polygon(hdc, MyPoints, 6); //mnohouholnik s vyplnou  
    SelectObject(hdc, hPenOld);
    SelectObject(hdc, hBrushOld);
    DeleteObject(hBrush);
    DeleteObject(hPen);	
}



void SipkaHore(HDC hdc, int rozmer, int x, int y)
{   HPEN hPen,hPenOld;
	HBRUSH hBrush, hBrushOld;
	int sipka_X,
		sipka_Y,
		sirka_sipky = 4,
		dlzka_sipky = 7;
	float proporcie_sipky = 1.9;
	hPen = CreatePen(PS_SOLID | PS_INSIDEFRAME, 1, RGB(0,190,255));  //0x00FF0000);   
	hBrush = CreateSolidBrush(RGB(150,200,255));  //0x0080FFFF); 
	hPenOld = (HPEN) SelectObject(hdc, hPen);  
	hBrushOld = (HBRUSH)SelectObject(hdc, hBrush);
	RoundRect(hdc, x, y, x + rozmer, y + rozmer, 8,8);
	DeleteObject(hPen); 
	DeleteObject(hBrush);
    sipka_X = x + rozmer/2;
	sipka_Y = y + rozmer - (rozmer - proporcie_sipky * dlzka_sipky)/2;
    //definovanie bodov nadvazujucich useciek
	POINT MyPoints[6] = {sipka_X, 				sipka_Y,
						 sipka_X, 				sipka_Y - dlzka_sipky,
						 sipka_X + sirka_sipky, sipka_Y - dlzka_sipky,
						 sipka_X, 				sipka_Y - proporcie_sipky * dlzka_sipky,
						 sipka_X - sirka_sipky, sipka_Y - dlzka_sipky,
						 sipka_X, 				sipka_Y - dlzka_sipky};
	hBrush = CreateSolidBrush(RGB(80,100,120));  //farba sipky
    hPen = CreatePen(PS_SOLID, 2, RGB(80,100,120));  //farba vyplne sipky
    SelectObject(hdc, hPen);
    SelectObject(hdc, hBrush);
    //Nakresli sadu nadvazujucich useciek, na zaklade definovanych bodov. ...
    //...Cislo 6 udava pocet useciek. Moze byt mensi alebo rovny poctu bodov.
    //Polyline(hdc, MyPoints, 6); //mnohouholnik bez vyplne
    Polygon(hdc, MyPoints, 6); //mnohouholnik s vyplnou  
    SelectObject(hdc, hPenOld);
    SelectObject(hdc, hBrushOld);
    DeleteObject(hBrush);
    DeleteObject(hPen);	
}



void SipkaDole(HDC hdc, int rozmer, int x, int y)
{   HPEN hPen,hPenOld;
	HBRUSH hBrush, hBrushOld;
	int sipka_X,
		sipka_Y,
		sirka_sipky = 4,
		dlzka_sipky = 7;
	float proporcie_sipky = 1.9;
	hPen = CreatePen(PS_SOLID | PS_INSIDEFRAME, 1, RGB(0,190,255));  //0x00FF0000);   
	hBrush = CreateSolidBrush(RGB(150,200,255));  //0x0080FFFF); 
	hPenOld = (HPEN) SelectObject(hdc, hPen);  
	hBrushOld = (HBRUSH)SelectObject(hdc, hBrush);
	RoundRect(hdc, x, y, x + rozmer, y + rozmer, 8,8);
	DeleteObject(hPen); 
	DeleteObject(hBrush);
    sipka_X = x + rozmer/2;
	sipka_Y = y + (rozmer - proporcie_sipky * dlzka_sipky)/2;
    //definovanie bodov nadvazujucich useciek
	POINT MyPoints[6] = {sipka_X, 				sipka_Y,
						 sipka_X, 				sipka_Y + dlzka_sipky,
						 sipka_X + sirka_sipky,	sipka_Y + dlzka_sipky,
						 sipka_X, 				sipka_Y + proporcie_sipky * dlzka_sipky,
						 sipka_X - sirka_sipky, sipka_Y + dlzka_sipky,
						 sipka_X, 				sipka_Y + dlzka_sipky};
	hBrush = CreateSolidBrush(RGB(80,100,120));  //farba sipky
    hPen = CreatePen(PS_SOLID, 2, RGB(80,100,120));  //farba vyplne sipky
    SelectObject(hdc, hPen);
    SelectObject(hdc, hBrush);
    //Nakresli sadu nadvazujucich useciek, na zaklade definovanych bodov. ...
    //...Cislo 6 udava pocet useciek. Moze byt mensi alebo rovny poctu bodov.
    //Polyline(hdc, MyPoints, 6); //mnohouholnik bez vyplne
    Polygon(hdc, MyPoints, 6); //mnohouholnik s vyplnou  
    SelectObject(hdc, hPenOld);
    SelectObject(hdc, hBrushOld);
    DeleteObject(hBrush);
    DeleteObject(hPen);	
}



void Okienko(HDC hdc, int farba_pera, int farba_stetca, int zaoblenie, int x, int y, int sirka, int vyska)
{	HPEN hPen, hPenOld;
  	HBRUSH hBrush, hBrushOld;
  	hPen = CreatePen(PS_SOLID | PS_INSIDEFRAME, 1, farba_pera);  //0x00FF0000);   
  	hPenOld = (HPEN)SelectObject(hdc, hPen);  
  	hBrush = CreateSolidBrush(farba_stetca);  //0x0080FFFF); 
 	hBrushOld = (HBRUSH)SelectObject(hdc, hBrush);
  	RoundRect(hdc, x, y, x + sirka, y + vyska, zaoblenie, zaoblenie);	
  	SelectObject(hdc, hPenOld);
  	SelectObject(hdc, hBrushOld);
  	DeleteObject(hPen); 
    DeleteObject(hBrush);
	
}



void LedSvetlo(HDC hdc, int farba_pera, int farba_stetca, int zaoblenie, RECT rect)
{	HPEN hPen, hPenOld;
  	HBRUSH hBrush, hBrushOld;
  	hPen = CreatePen(PS_SOLID | PS_INSIDEFRAME, 1, farba_pera);  //0x00FF0000);   
  	hPenOld = (HPEN)SelectObject(hdc, hPen);  
  	hBrush = CreateSolidBrush(farba_stetca);  //0x0080FFFF); 
 	hBrushOld = (HBRUSH)SelectObject(hdc, hBrush);
  	RoundRect(hdc, rect.left, rect.top, rect.right, rect.bottom, zaoblenie, zaoblenie);	
  	SelectObject(hdc, hPenOld);
  	SelectObject(hdc, hBrushOld);
  	DeleteObject(hPen); 
    DeleteObject(hBrush);
	
}



void Usecka(HDC hdc, COLORREF farba, int hrubka, int x, int y, int dlzka, int vyska)
{   HPEN hPen, hPenOld;
    hPen= CreatePen(PS_SOLID, hrubka, farba);
    hPenOld = (HPEN)SelectObject(hdc, hPen);
    MoveToEx(hdc, x, y, NULL);
    LineTo(hdc, dlzka, vyska);
    SelectObject(hdc, hPenOld);
    DeleteObject(hPen);
}







void PohybMysiDesktop(HWND hwnd, HDC* hdcMem)
{   POINT point;
	SIZE rozmery_textu;
	RECT rect;
	GetClientRect(hwnd, &rect); 
    GetCursorPos(&point);
    int f, x = rect.left + 10, xRGB = rect.right-(4*38+15), vyska_listy = 17, farba_listy = 170;
    //COLORREF farba_listy = 
    //TCHAR text[100], zobrazenie[100];
    //for(f = 0; f < 100; f++)
		//zobrazenie[f] = 0;
    //_stprintf(text, " x=%d  y=%d  ", point.x, point.y);
    //lstrcat(zobrazenie, text);
    HDC hdc = GetDC(NULL);
    COLORREF barva = GetPixel(hdc, point.x, point.y);
	BYTE cervena = GetRValue(barva);
    BYTE zelena = GetGValue(barva);
    BYTE modra = GetBValue(barva);
	//_stprintf(text, "  R=%d  G=%d  B=%d  ", cervena, zelena, modra);
	//lstrcat(zobrazenie, text);
    ReleaseDC(NULL, hdc);
    //SetWindowText(hwnd, zobrazenie);
    //Napis(*hdcMem, &rozmery_textu, zobrazenie, -1, 10, rect.bottom-15, RGB(0,0,0), -11, 0, 0, TEXT("Segoe UI"));	  
	Okienko(*hdcMem, RGB(farba_listy-25,farba_listy-25,farba_listy-25), RGB(farba_listy,farba_listy,farba_listy), 0, rect.left, rect.bottom-vyska_listy, rect.right-rect.left, vyska_listy);	
	Napis(*hdcMem, &rozmery_textu, "x=%d", point.x, x, rect.bottom-15, RGB(255,255,0), -11, 0, 0, TEXT("Segoe UI"));	  
    Napis(*hdcMem, &rozmery_textu, "y=%d", point.y, x+40, rect.bottom-15, RGB(0,250,250), -11, 0, 0, TEXT("Segoe UI"));	  
    Napis(*hdcMem, &rozmery_textu, "R=%d", cervena, xRGB+38+15, rect.bottom-15, RGB(255,0,0), -11, 0, 0, TEXT("Segoe UI"));	  
    Napis(*hdcMem, &rozmery_textu, "G=%d", zelena, xRGB+2*38+14, rect.bottom-15, RGB(0,255,0), -11, 0, 0, TEXT("Segoe UI"));	  
    Napis(*hdcMem, &rozmery_textu, "B=%d", modra, xRGB+3*38+15, rect.bottom-15, RGB(0,0,255), -11, 0, 0, TEXT("Segoe UI"));	  
}




//***********************************************************************************
//*************************** FUNKCIE PRE PRACU SO SUBORMI **************************
//***********************************************************************************



void PointPoleDoTxt(LPCTSTR nazov_suboru, POINT* pole, int PocetPoloziek)
{	int f;
	FILE *fc = fopen(nazov_suboru, "w");
	for(f = 0; f < PocetPoloziek; f++)
		fprintf(fc, "%d,%d\n", pole[f].x, pole[f].y);		
	fclose(fc);	
}




// zapis pola cisel farieb formatu COLORREF do textoveho suboru, v textovej podobe
void CislaFariebDoTXT(LPCTSTR nazov_suboru, // nazov txt suboru
 		   			 LPCTSTR format,  	//sposob otvorenia suboru.
		   			 COLORREF* pole,         // pole farieb na zapis do txt suboru
					 int velkost_pola)  // pocet poloziek pola
{	FILE *fa;
	char retazec[100];
	int f, oddelovac = 0;
	fa = fopen(nazov_suboru, format);
	for(f = 0; f < velkost_pola; f++)
	{	if((++oddelovac >= 6) || (f == 1)) 
		{	fprintf(fa, "\n");
			oddelovac = 0;
		}	
		fprintf(fa, "%d,  ", pole[f]);	
	}
	fprintf(fa, "\n");
	fclose(fa);
}



void PoleCiselDoTXT(LPCTSTR nazov_suboru, // nazov txt suboru
 		   			 LPCTSTR mode,  	 //mod otvorenia suboru
		   			 int* pole,         // pole farieb na zapis do txt suboru
					 int velkost_pola)  // pocet poloziek pola
{	FILE *fa;
	int f;
	fa = fopen(nazov_suboru, mode);
	for(f = 0; f < velkost_pola; f++)
		fprintf(fa, "%d, ", pole[f]);	
	fprintf(fa, "\n");
	fclose(fa);
}



// zapis pola cisel farieb formatu COLORREF do binarneho suboru
int CislaFariebDoBIN(LPCTSTR nazov_suboru, // nazov suboru
					 LPCTSTR mode,  	 //mod otvorenia suboru
		   			 COLORREF* pole,         // pole farieb na zapis do suboru
					 int velkost_pola)  // pocet poloziek pola
{	FILE *fa;
	int navrat;
	fa = fopen(nazov_suboru, mode);
    navrat = fwrite(pole, //ukazatel na zaciatok struktury, pamati al. pola cisel
					sizeof(COLORREF), //bytova velkost zapisovanych cisel (zapisovaci ramec)
					velkost_pola, //pocet poloziek, ktore zapiseme (v tomto pripade 100*sizeof(int) bajtov)
					fa); //premenna otvoreneho suboru, kam sa zapisuje
					//navratova hodnota je pocet zapisanych poloziek. (nie bytov) V pripade chyby je nastavena globalna premenna errno
	fclose(fa);
	return navrat;
}



// zapis pola cisel farieb formatu COLORREF do binarneho suboru
int CislaFariebZ_BIN(LPCTSTR nazov_suboru, // nazov txt suboru
		   			 COLORREF* pole,         // pole farieb na zapis do txt suboru
					 int velkost_pola)  // pocet poloziek pola
{	FILE *fa;
	int navrat;
	fa = fopen(nazov_suboru, "rb");
    navrat = fread(pole, //ukazatel na zaciatok struktury, pamati al. pola cisel
				   sizeof(COLORREF), //bytova velkost citanych cisel (citaci ramec)
				   velkost_pola, //pocet poloziek, ktore citame (v tomto pripade 100*sizeof(int) bajtov)
				   fa); //premenna otvoreneho suboru, kam sa zapisuje
					//navratova hodnota je pocet zapisanych poloziek. (nie bytov) V pripade chyby je nastavena globalna premenna errno
	fclose(fa);
	return navrat;
}



//ulozenie cisla do binarneho suboru
int CislaDoBIN(LPCTSTR nazov_suboru, LPCTSTR mode, int cislo)  
{	FILE *fa;
	int navrat;
	fa = fopen(nazov_suboru, mode);
	if(cislo > -1)
    	navrat = fwrite(&cislo, sizeof(int), 1, fa); 
	fclose(fa);
	return navrat;
}



//ulozenie cisla textoveho suboru
int CislaDoTXT(LPCTSTR nazov_suboru, LPCTSTR mode, int cislo)  
{	FILE *fa;
	int navrat;
	fa = fopen(nazov_suboru, mode);
	if(cislo > -1)
    	navrat = fprintf(fa, "%d, ", cislo);
	fclose(fa);
	return navrat;
}



void PointPoleCiselDoTXT(LPCTSTR nazov_suboru, // nazov txt suboru
 		   			 	LPCTSTR mode,  	 //mod otvorenia suboru
		   			 	POINT* pole,         // pole farieb na zapis do txt suboru
					 	int velkost_pola)  // pocet poloziek pola
{	FILE *fa;
	int f, oddelovac = 0;
	fa = fopen(nazov_suboru, mode);
	for(f = 0; f < velkost_pola; f++)
	{	fprintf(fa, "{%d,%d}, ", pole[f].x, pole[f].y);	
		if(++oddelovac >= 10) 
		{	fprintf(fa, "\n");
			oddelovac = 0;
		}	
	}
	fprintf(fa, "\n");
	fclose(fa);
}



// funkcia skopiruje cisla zo suboru do pola, ktoreho velkost si sama alokuje podla poctu poloziek v tom subore.
// funkcia vrati adresu zaciatku alokovanej pamati s cislami, a do posledneho parametru aj velkost toho pola s cislami (pocet cisel).
int* CislaZoSuboruDoPola(LPCTSTR nazov_suboru, LPCTSTR mode, int* pocet2)
{	FILE *fa;	
	int pocet = 0, test, f;
	static int *pamat;
	if((fa = fopen(nazov_suboru, mode)) != 0)
	{	while(1)
		{	fread(&test, sizeof(int), 1, fa);
			if(feof(fa))
				break;
			pocet++;
		}
		pamat = (int*) calloc(pocet+10, sizeof(int));
		fseek(fa, 0, SEEK_SET);
		fread(pamat, sizeof(int), pocet, fa);
		fclose(fa);
	}
	else
		pamat = 0;
	*pocet2 = pocet;
	return pamat;
}




